USE [nhesabdb]
GO

/****** Object:  Table [dbo].[SaleDelete_tbl]    Script Date: 16/10/1402 10:06:31 ب.ظ ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[SaleDelete_tbl](
	[SaleDetailID] [int] IDENTITY(1,1) NOT NULL,
	[SaleFaktorID] [int] NULL,
	[KalaID] [int] NOT NULL,
	[KalaName] [nvarchar](max) NULL,
	[KalaCount] [float] NOT NULL,
	[KalaUnitPrice] [bigint] NOT NULL,
	[KalaType] [int] NULL,
	[Temp1] [nvarchar](50) NULL,
	[Temp2] [nvarchar](50) NULL,
	[Number1] [int] NULL,
	[Number2] [int] NULL,
	[Bit1] [bit] NULL,
	[Bit2] [bit] NULL,
	[Number3] [bigint] NULL,
	[DeleteOK] [bit] NULL,
	[Khadamat] [bit] NULL,
	[SoodTemp] [bigint] NULL,
	[FaktorNumber] [nvarchar](50) NULL,
	[PersonID] [int] NULL,
	[PersonName] [nvarchar](50) NULL,
	[BuyDate] [nvarchar](10) NULL,
	[TimeIns] [time](7) NULL,
	[maliyat] [bigint] NULL,
	[afzoodeh] [bigint] NULL,
	[jamekol] [bigint] NULL,
	[Typefak] [int] NULL,
	[refback] [int] NULL,
	[Dateins] [datetime] NULL,
 CONSTRAINT [PK_SaleDelete_tbl] PRIMARY KEY CLUSTERED 
(
	[SaleDetailID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_KalaCount]  DEFAULT ((0)) FOR [KalaCount]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_KalaUnitPrice]  DEFAULT ((0)) FOR [KalaUnitPrice]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_KalaType]  DEFAULT ((0)) FOR [KalaType]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_Temp1]  DEFAULT (N'خروجی(فاکتور فروش)') FOR [Temp1]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_Number2]  DEFAULT ((0)) FOR [Number2]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_Bit1]  DEFAULT ((0)) FOR [Bit1]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_Bit2]  DEFAULT ((0)) FOR [Bit2]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_Number3]  DEFAULT ((0)) FOR [Number3]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_DeleteOK]  DEFAULT ((0)) FOR [DeleteOK]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_Khadamat]  DEFAULT ((0)) FOR [Khadamat]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_buyamounts]  DEFAULT ((0)) FOR [SoodTemp]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_TimeIns]  DEFAULT (getdate()) FOR [TimeIns]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_maliyat]  DEFAULT ((0)) FOR [maliyat]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_afzoodeh]  DEFAULT ((0)) FOR [afzoodeh]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_jamekol]  DEFAULT ((0)) FOR [jamekol]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  DEFAULT ((0)) FOR [Typefak]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  DEFAULT ((0)) FOR [refback]
GO

ALTER TABLE [dbo].[SaleDelete_tbl] ADD  CONSTRAINT [DF_SaleDelete_tbl_Dateins]  DEFAULT (getdate()) FOR [Dateins]
GO

ALTER TABLE [dbo].[SaleDelete_tbl]  WITH CHECK ADD  CONSTRAINT [FK_SaleDelete_tbl_Kala_tbl] FOREIGN KEY([KalaID])
REFERENCES [dbo].[Kala_tbl] ([KalaID])
GO

ALTER TABLE [dbo].[SaleDelete_tbl] CHECK CONSTRAINT [FK_SaleDelete_tbl_Kala_tbl]
GO

ALTER TABLE [dbo].[SaleDelete_tbl]  WITH CHECK ADD  CONSTRAINT [FK_SaleDelete_tbl_SaleFaktor_tbl] FOREIGN KEY([SaleFaktorID])
REFERENCES [dbo].[SaleFaktor_tbl] ([SaleFaktorID])
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[SaleDelete_tbl] CHECK CONSTRAINT [FK_SaleDelete_tbl_SaleFaktor_tbl]
GO


CREATE TRIGGER dbo.TrSaleDetail_tbl
ON dbo.SaleDetail_tbl
AFTER DELETE
AS
BEGIN
SET NOCOUNT ON;
INSERT INTO dbo.SaleDelete_tbl(SaleFaktorID , KalaID ,KalaName,KalaCount,KalaUnitPrice,KalaType,Temp1,Temp2,Number1,Number2,Bit1,Bit2,Number3,DeleteOK,Khadamat,SoodTemp,FaktorNumber,PersonID,PersonName,BuyDate,TimeIns,maliyat,afzoodeh,jamekol,Typefak,refback)
SELECT SaleFaktorID , KalaID ,KalaName,KalaCount,KalaUnitPrice,KalaType,Temp1,Temp2,Number1,Number2,Bit1,Bit2,Number3,DeleteOK,Khadamat,SoodTemp,FaktorNumber,PersonID,PersonName,BuyDate,TimeIns,maliyat,afzoodeh,jamekol,Typefak,refback
FROM
deleted d;
END




